#ifndef __CIRCLE_H
#define __CIRCLE_H

#include "stdafx.h"
#include <cmath>

class Circle {
public:
    friend bool touching(const Circle &c1, const Circle &c2);
    // Two circles are touching if the distance from one's
    // center to that of the other is less than or equal to
    // the sum of their radii.
    Circle(double radius=1, double centerX = 0, double centerY = 0)
        :radius(radius), centerX(centerX), centerY(centerY) {
        if (radius < 1) this->radius = 1;
    }
    // Some access functions.
    double getArea() const { return pi*radius*radius; }
    double getRadius() const { return radius; }
    double getX() const { return centerX; }
    double getY() const { return centerY; }
    Circle operator + (Circle c) {
        double sumAreas = getArea() + c.getArea();
        double newRadius = sqrt(sumAreas/pi);
        double newCenterX =       
            (centerX*getArea()+c.centerX*c.getArea())/sumAreas;
        double newCenterY =
            (centerY*getArea()+c.centerY*c.getArea())/sumAreas;
        return Circle(newRadius, newCenterX, newCenterY);
    }
    void randomizeRadius(int radiusLowerLimit, 
                            int radiusUpperLimit) {
        radius = rand() 
                    % (radiusUpperLimit - radiusLowerLimit + 1) 
                    + radiusLowerLimit;
    }
    void randomizeCenter(int xLower, int xUpper, 
                            int yLower, int yUpper) {
        centerX = rand() % (xUpper - xLower + 1) + xLower;
        centerY = rand() % (yUpper - yLower + 1) + yLower;
    }
    virtual void draw(CDC &dc);  // Draw the circle.
    virtual void erase(CDC &dc); // Erase the circle.
    static const double pi;
protected:
    double radius;
    double centerX, centerY;
};

#endif
